# モジュール宣言/変数初期化
use strict;
my %cf;
#┌─────────────────────────────────
#│ Web Quiz : init.cgi - 2015/01/31
#│ copyright (c) KentWeb, 1997-2015
#│ http://www.kent-web.com/
#└─────────────────────────────────
$cf{version} = 'Web Quiz v1.1';
#┌─────────────────────────────────
#│ [注意事項]
#│ 1. このプログラムはフリーソフトです。このプログラムを使用した
#│    いかなる損害に対して作者は一切の責任を負いません。
#│ 2. 設置に関する質問はサポート掲示板にお願いいたします。
#│    直接メールによる質問は一切お受けいたしておりません。
#└─────────────────────────────────

#===========================================================
# ■ 基本設定
#===========================================================

# 管理用パスワード
$cf{password} = '0123';

# タイトル名
$cf{quiz_ttl} = "Web Quiz";

# クイズ設問数
$cf{quiz_all} = 5;

# 選択肢の数
# 例 : 「4」だと四者択一式
$cf{quiz_op} = 4;

# 結果の答え合わせを表示する
# 0 : no
# 1 : yes
$cf{check_ans} = 0;

# 再チャレンジまでの時間（分）
$cf{chal_time} = 3;

# ランキングの表示順位
$cf{rank_list} = 10;

# クイズプログラム【URLパス】
$cf{quiz_cgi} = './quiz.cgi';

# 管理プログラム【URLパス】
$cf{admin_cgi} = './admin.cgi';

# データディレクトリ【サーバパス】
$cf{datadir} = './data';

# テンプレートディレクトリ【サーバパス】
$cf{tmpldir} = './tmpl';

# 画像ディレクトリ【サーバパス】
$cf{imgdir} = './img';

# 画像ディレクトリ【URLパス】
$cf{imgurl} = './img';

# アイコンディレクトリ【URLパス】
$cf{iconurl} = './img/icon';

# 戻り先【URLパス】
$cf{home_url} = '../index.html';

# ログファイルの保管件数
# → これを超えると古い順に自動削除されます。
$cf{log_max} = 200;

# 最大受理サイズ
$cf{maxdata} = 1024000;

#===========================================================
# ■ 設定完了
#===========================================================

# 設定値を返す
sub set_init {
	return %cf;
}

#-----------------------------------------------------------
#  日付フォーマット
#-----------------------------------------------------------
sub chg_date {
	my $time = shift;
	
	my ($min,$hour,$mday,$mon) = (localtime($time))[1..4];
	sprintf("%02d/%02d %02d:%02d", $mon+1,$mday,$hour,$min);
}


1;

