#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ ROBOCHAT : check.cgi - 2011/09/24
#│ Copyright (c) KentWeb
#│ http://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);

# 外部ファイル取り込み
require './init.cgi';
my %cf = &init;

print <<EOM;
Content-type: text/html

<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8">
<title>Check Mode</title>
</head>
<body>
<b>Check Mode: [ $cf{version} ]</b>
<ul>
EOM

# ファイル
my %log = (
	logfile => 'データファイル',
	memfile => '在室ファイル',
	denyfile => '拒否ファイル',
	dic1file => '辞書基本ファイル',
	dic2file => '辞書応用ファイル',
	);
foreach ( keys(%log) ) {
	if (-e $cf{$_}) {
		print "<li>$log{$_}パス : OK\n";
	} else {
		print "<li>$log{$_}パス : NG\n";
	}
	if (-r $cf{$_} && -w $cf{$_}) {
		print "<li>$log{$_}パーミッション : OK\n";
	} else {
		print "<li>$log{$_}パーミッション : NG\n";
	}
}

# テンプレート
my @tmpl = qw|data error form form2 out|;
foreach (@tmpl) {
	if (-f "$cf{tmpldir}/$_.html") {
		print "<li>テンプレート( $_.html ) : OK\n";
	} else {
		print "<li>テンプレート( $_.html ) : NG\n";
	}
}

print <<EOM;
</ul>
</body>
</html>
EOM
exit;


