#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ ROBOCHAT : init.cgi - 2011/10/02
#│ Copyright (c) KentWeb
#│ http://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);

# 設定ファイル認識
require "./init.cgi";
my %cf = &init;

# データ受理
my %in = &parse_form;

&deny_host;
if ($in{mode} eq 'form') { &form1; }
if ($in{mode} eq 'into') { &form2; }
if ($in{comment} && $in{mode} eq 'regist') { &regist; }
if ($in{mode} eq 'out') { &room_out; }
if ($in{mode} eq 'rank') { &rank_list; }
&chat_data;

#-----------------------------------------------------------
#  フォーム1 : 入室画面
#-----------------------------------------------------------
sub form1 {
	# クッキー取得
	my ($ck_nam,$ck_eml,$ck_col,$ck_ret,$ck_lin) = &get_cookie;
	$ck_col = $ck_col ne '' ? $ck_col : 0;
	$ck_ret = $ck_ret ne '' ? $ck_ret : $cf{retime_defo};
	$ck_lin = $ck_lin ne '' ? $ck_lin : $cf{lines_defo};

	my ($op_retime,$op_lines,$colors);
	foreach (@{$cf{retime}}) {
		if ($ck_ret == $_) {
			$op_retime .= qq|<option value="$_" selected>$_秒\n|;
		} else {
			$op_retime .= qq|<option value="$_">$_秒\n|;
		}
	}
	foreach (@{$cf{lines}}) {
		if ($ck_lin == $_) {
			$op_lines .= qq|<option value="$_" selected>$_行\n|;
		} else {
			$op_lines .= qq|<option value="$_">$_行\n|;
		}
	}
	foreach (0 .. $#{$cf{colors}}) {
		my ($col,undef) = split(/,/, $cf{colors}->[$_]);
		if ($ck_col == $_) {
			$colors .= qq|<input type="radio" name="color" value="$_" checked>|;
		} else {
			$colors .= qq|<input type="radio" name="color" value="$_">|;
		}
		$colors .= qq|<span style="color:$col">■</span>\n|;

		if ($_ == int(@{$cf{colors}}/2)-1) { $colors .= "<br>\n"; }
	}

	open(IN,"$cf{tmpldir}/form.html") or &error("open err: form.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!chat_title!/$cf{chat_title}/g;
	$tmpl =~ s/!chat_cgi!/$cf{chat_cgi}/g;
	$tmpl =~ s/!homepage!/$cf{homepage}/g;
	$tmpl =~ s/!colors!/$colors/g;
	$tmpl =~ s/!name!/$ck_nam/g;
	$tmpl =~ s/!email!/$ck_eml/g;
	$tmpl =~ s/<!-- op_retime -->/$op_retime/g;
	$tmpl =~ s/<!-- op_lines -->/$op_lines/g;

	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  フォーム2 : 発言フォーム
#-----------------------------------------------------------
sub form2 {
	&regist('into');

	# クッキー保存
	&set_cookie($in{name},$in{email},$in{color},$in{retime},$in{lines});

	my ($op_retime,$op_lines,$op_colors,$op_faces);
	foreach (@{$cf{retime}}) {
		if ($in{retime} == $_) {
			$op_retime .= qq|<option value="$_" selected>$_秒\n|;
		} else {
			$op_retime .= qq|<option value="$_">$_秒\n|;
		}
	}
	foreach (@{$cf{lines}}) {
		if ($in{lines} == $_) {
			$op_lines .= qq|<option value="$_" selected>$_行\n|;
		} else {
			$op_lines .= qq|<option value="$_">$_行\n|;
		}
	}
	foreach (0 .. $#{$cf{colors}}) {
		my (undef,$nam) = split(/,/, $cf{colors}->[$_]);
		if ($in{color} == $_) {
			$op_colors .= qq|<option value="$_" selected>$nam\n|;
		} else {
			$op_colors .= qq|<option value="$_">$nam\n|;
		}
	}
	foreach (@{$cf{faces}}) {
		$op_faces .= qq|<option value="$_">$_\n|;
	}

	open(IN,"$cf{tmpldir}/form2.html") or &error("open err: form2.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/<!-- ranking_begin -->.+<!-- ranking_end -->//s if ($cf{ranking});
	$tmpl =~ s/!chat_title!/$cf{chat_title}/g;
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!homepage!/$cf{homepage}/g;
	$tmpl =~ s/!name!/$in{name}/g;
	$tmpl =~ s/!email!/$in{email}/g;
	$tmpl =~ s/!enam!/&url_encode($in{name})/eg;
	$tmpl =~ s/<!-- op_retime -->/$op_retime/g;
	$tmpl =~ s/<!-- op_lines -->/$op_lines/g;
	$tmpl =~ s/<!-- op_faces -->/$op_faces/g;
	$tmpl =~ s/<!-- op_colors -->/$op_colors/g;

	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  記事表示
#-----------------------------------------------------------
sub chat_data {
	my $meta;
	if ($in{retime} != 0) {
		my $enam = &url_encode($in{name});
		$meta = qq|<meta http-equiv="refresh" content="$in{retime}; url=$cf{chat_cgi}?retime=$in{retime}&lines=$in{lines}&name=$enam">|;
	}

	# リロード/行数
	my $retime = $in{retime} ? "$in{retime}秒" : "手動";
	$in{lines} ||= $cf{lines_defo};

	# 在室
	my ($num,$member) = &member;

	open(IN,"$cf{tmpldir}/data.html") or &error("open err: data.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!member!/$member/g;
	$tmpl =~ s/!num!/$num/g;
	$tmpl =~ s/!retime!/$retime/g;
	$tmpl =~ s/!lines!/$in{lines}/g;
	$tmpl =~ s/<!-- meta_refresh -->/$meta/;
	$tmpl =~ s/!lines!/$in{lines}/g;

	# テンプレート分割
	my ($head,$loop,$foot);
	if ($tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s) {
		($head,$loop,$foot) = ($1,$2,$3);
	} else {
		&error("テンプレートが不正です");
	}

	print "Content-type: text/html\n\n";
	print $head;

	my $i;
	open(IN,"$cf{logfile}") or &error("open err: $cf{logfile}");
	while (<IN>) {
		$i++;
		my ($date,$name,$eml,$com,$col,undef,undef) = split(/<>/);

		my $tmp = $loop;
		$tmp =~ s|!name!|<span style="color:$col">$name</span>|g;
		$tmp =~ s|!comment!|<span style="color:$col">$com</span>|g;
		$tmp =~ s/!date!/$date/g;
		print $tmp;

		# 表示数制限
		last if ($i >= $in{lines});
	}
	close(IN);

	# フッタ
	&footer($foot);
}

#-----------------------------------------------------------
#  書込処理
#-----------------------------------------------------------
sub regist {
	my $job = shift;

	# 名前の入力がなければエラー
	if ($in{name} eq "") { &error("名前の入力がありません"); }

	# 時間/ホスト
	my $host = $ENV{REMOTE_ADDR};
	my ($sec,$min,$hour,$mday,$mon) = localtime();
	my $date = sprintf("%s/%s-%02d:%02d:%02d",$mon+1,$mday,$hour,$min,$sec);

	my ($name,$email,$color,$res);
	if ($job eq 'into') {
		$in{comment} = "<b>$in{name}</b>$cf{msg_in}";
		$email = "";
		$name  = $cf{master};
		$color = $cf{rep_color};

	} elsif ($job eq 'out') {
		$in{comment} = "<b>$in{name}</b>$cf{msg_out}";
		$email = "";
		$name  = $cf{master};
		$color = $cf{rep_color};

	} else {
		if ($in{email} eq "") {
			$name = "$cf{pointer} <b>$in{name}</b>";
		} else {
			$name = qq|<a href="mailto:$in{email}">$cf{pointer}</a> <b>$in{name}</b>|;
		}
		$email = $in{email};
		$color = (split(/,/, $cf{colors}->[$in{color}]))[0];

		# 応答
		my $res_key;
		$cf{roboname} =~ s/([\*\+\.\?\^\$\[\-\]\|\(\)\\])/\\$1/g;
		if ($in{comment} =~ /誰か|$cf{roboname}/) {
			$res_key++;
		} else {
			# 在室者
			my $n = 0;
			open(IN,"$cf{memfile}") or &error("open err: $cf{memfile}");
			++$n while(<IN>);
			close(IN);

			if ($n <= 1) { $res_key++; }
		}

		# ロボット発言
		$res = &bot_reply if ($res_key);
	}

	# ログを開く
	open(DAT,"+< $cf{logfile}") || &error("open err: $cf{logfile}");
	eval "flock(DAT, 2);";
	my @data = <DAT>;

	## clear と入力することで自分の記事を削除
	if ($in{comment} eq 'clear'){
		my @temp;
		my $match;
		foreach (@data) {
			my ($hos) = (split(/<>/))[5];
			if ($host eq $hos) { $match = 1; }
			else { push(@temp,$_); }
		}
		if ($match) {
			@data = @temp;
			$in{comment} = "All Clear (^-^)v";
		}
	}

	# 最大記事数
	while ($cf{maxlog} <= @data) { pop(@data); }

	$in{comment} .= " $in{face}" if ($in{face});
	$in{comment} =~ s|\(\*\＾\＾\*\)|(<span style="color:red">*</span>＾＾<span style="color:red">*</span>)|g;

	# ログをフォーマットして更新
	unshift (@data,"$date<>$name<>$email<>$in{comment}<>$color<>$host<>\n");
	unshift (@data,"$date<>$cf{roboname}<><>$res<>$cf{robocol}<>robot<>\n") if ($res);
	seek(DAT, 0, 0);
	print DAT @data;
	truncate(DAT, tell(DAT));
	close(DAT);
}

#-----------------------------------------------------------
#  退室処理
#-----------------------------------------------------------
sub room_out {
	&regist('out');
	&member('out');

	open(IN,"$cf{tmpldir}/out.html") or &error("open err: out.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!homepage!/$cf{homepage}/g;
	$tmpl =~ s/!chat_title!/$cf{chat_title}/g;
	$tmpl =~ s/!name!/$in{name}/g;

	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  エラー画面
#-----------------------------------------------------------
sub error {
	my $err = shift;

	open(IN,"$cf{tmpldir}/error.html") or die;
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!error!/$err/g;

	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  在室管理
#-----------------------------------------------------------
sub member {
	my $job = shift;

	# 時間/IP取得
	my $now = time;
	my $addr = $ENV{REMOTE_ADDR};

	my $member = "$cf{roboname}◇";
	my ($i,$flg,@log);
	open(DAT,"+< $cf{memfile}") or &error("open err: $cf{memfile}");
	eval "flock(DAT, 2);";
	while(<DAT>) {
		my ($time,$name,$ip) = split(/<>/);

		# 60秒以上発言のない者は削除
		if ($now - 60 > $time) {
			$flg = 1;
			next;
		}

		if ($addr eq $ip) {
			$flg = 2;

			# 退室者削除
			if ($job eq 'out') {
				next;

			# 時間/名前を更新
			} else {
				$name = $in{name};
				$_ = "$now<>$name<>$addr<>\n";
			}
		}

		# 更新用配列に追加
		push(@log,$_);

		# 参加者表示用文字列を作成
		if ($i % 2) {
			$member .= "$name◇";
			$i++;
		} else {
			$member .= "$name◆";
			$i++;
		}
	}

	# 新規参加者追加
	if (!$flg && $job ne 'out' && $in{name} ne '') {
		$flg = 3;
		push(@log,"$now<>$in{name}<>$addr<>\n");
		$member = $i % 2 ? "$member$in{name}◇" : "$member$in{name}◆";
	}

	# 参加者数
	my $num = @log + 1;

	# ファイル更新
	if ($job || $flg) {
		seek(DAT, 0, 0);
		print DAT @log;
		truncate(DAT, tell(DAT));
	}
	close(DAT);

	return ($num,$member);
}

#-----------------------------------------------------------
#  IPアクセス拒否
#-----------------------------------------------------------
sub deny_host {
	my $addr = $ENV{REMOTE_ADDR};
	my $flg;
	open(IN,"$cf{denyfile}") || &error("open err: $cf{denyfile}");
	while (<IN>) {
		chomp;
		next if (!$_);
		s/\*/\.\*/g;
		if ($addr =~ /$_/i) { $flg++; last; }
	}
	close(IN);

	&error('申し訳ありませんが現在ご利用できません') if ($flg);
}

#-----------------------------------------------------------
#  URLエンコード
#-----------------------------------------------------------
sub url_encode {
	local($_) = @_;

	s/(\W)/'%' . unpack('H2', $1)/eg;
	s/\s/+/g;
	$_;
}

#-----------------------------------------------------------
#  フッター
#-----------------------------------------------------------
sub footer {
	my $foot = shift;

	# 著作権表記（削除・改変禁止）
	my $copy = <<EOM;
<p style="margin-top:2em;text-align:center;font-family:verdana,helvetica,arial;font-size:10px;">
- <a href="http://www.kent-web.com/" target="_top">ROBOCHAT</a> -
</p>
EOM

	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		print "$1$copy$2\n";
	} else {
		print "$foot$copy\n";
		print "</body></html>\n";
	}
	exit;
}

#-----------------------------------------------------------
#  クッキー発行
#-----------------------------------------------------------
sub set_cookie {
	my @data = @_;

	my ($sec,$min,$hour,$mday,$mon,$year,$wday,undef,undef) = gmtime(time + 60*24*60*60);
	my @mon  = qw|Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec|;
	my @week = qw|Sun Mon Tue Wed Thu Fri Sat|;

	# 時刻フォーマット
	my $gmt = sprintf("%s, %02d-%s-%04d %02d:%02d:%02d GMT",
				$week[$wday],$mday,$mon[$mon],$year+1900,$hour,$min,$sec);

	# URLエンコード
	my $cook;
	foreach (@data) {
		s/(\W)/sprintf("%%%02X", unpack("C", $1))/eg;
		$cook .= "$_<>";
	}

	print "Set-Cookie: robo_chat=$cook; expires=$gmt\n";
}

#-----------------------------------------------------------
#  クッキー取得
#-----------------------------------------------------------
sub get_cookie {
	# クッキー取得
	my $cook = $ENV{HTTP_COOKIE};

	# 該当IDを取り出す
	my %cook;
	foreach ( split(/;/, $cook) ) {
		my ($key,$val) = split(/=/);
		$key =~ s/\s//g;
		$cook{$key} = $val;
	}

	# URLデコード
	my @cook;
	foreach ( split(/<>/, $cook{robo_chat}) ) {
		s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
		s/[&"'<>]//g;

		push(@cook,$_);
	}
	return @cook;
}

#-----------------------------------------------------------
#  ロボット発言
#-----------------------------------------------------------
sub bot_reply {
	# 基本辞書を探す
	my @res;
	open(IN,"$cf{dic1file}") or &error("open err: $cf{dic1file}");
	while(<IN>) {
		chomp;
		my (undef,$key,$val) = split(/<>/);
		$key =~ s/([\+\.\?\^\$\[\-\]\|\(\)\\])/\\$1/g;
		$key =~ s/\*/.*/g;

		if ($in{comment} =~ /$key/i) {
			push(@res,$val);
		}
	}
	close(IN);

	# 基本辞書にあった場合
	if (@res > 0) {
		my $res = @res == 1 ? $res[0] : $res[int(rand(@res))];
		$res =~ s/NAME/$in{name}/g;
		return $res;
	}

	# 応用辞書から1件抜き出す
	my $res;
	open(IN,"$cf{dic2file}") or &error("open err: $cf{dic2file}");
	rand($.) < 1 and $res = $_ while <IN>;
	close(IN);

	chomp($res);
	my (undef,$res) = split(/<>/, $res);
	$res =~ s/NAME/$in{name}/g;
	return $res;
}

