# モジュール宣言/変数初期化
use strict;
my %cf;
#┌─────────────────────────────────
#│ Web Scheduler : init.cgi - 2022/03/28
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└─────────────────────────────────
$cf{version} = 'WebScheduler v4.1';
#┌─────────────────────────────────
#│ [注意事項]
#│ 1. このプログラムはフリーソフトです。このプログラムを使用した
#│    いかなる損害に対して作者は一切の責任を負いません。
#│ 2. 設置に関する質問はサポート掲示板にお願いいたします。
#│    直接メールによる質問は一切お受けいたしておりません。
#└─────────────────────────────────

#===========================================================
# ■ 基本設定
#===========================================================

# 書き込みパスワード（英数字で8文字以内）
$cf{password} = '0123';

# タイトル
$cf{title} = 'WebScheduler';

# 本体CGIプログラム【URLパス】
$cf{index_cgi} = './schedule.cgi';

# 戻り先【URLパス】
$cf{homepage} = '../index.html';

# 通番ファイル【サーバパス】
$cf{numfile} = './data/num.dat';

# ログファイルディレクトリ【サーバパス】
$cf{logdir} = './data/log';

# テンプレートディレクトリ【サーバパス】
$cf{tmpldir} = './tmpl';

# アップロードディレクトリ
# → 順に、サーバパス、URLパス
$cf{upldir} = './upl';
$cf{uplurl} = './upl';

# 共通ディレクトリ【URLパス】
$cf{cmnurl} = './cmn';

# カレンダーの色指定
# → 順に、日～土、祝日、本日
$cf{wkcol} = [
	'red',
	'black',
	'black',
	'black',
	'black',
	'black',
	'blue',
	'#f20da2',
	'#feefcc',
	];

# 週表示
$cf{week} = ['日','月','火','水','木','金','土'];

# 最大受理サイズ
$cf{maxdata} = 512000;

# 添付用アイコン定義
$cf{icon} = {
		xls  => 'excel.png',
		xlsx => 'excel.png',
		doc  => 'word.png',
		docx => 'word.png',
		ppt  => 'ppt.png',
		pptx => 'ppt.png',
		pdf  => 'pdf.png',
		zip  => 'zip.png',
		};

#===========================================================
# ■ 設定完了
#===========================================================

# 設定値を返す
sub set_init { return %cf; }


1;

