#!/usr/local/bin/perl

#┌─────────────────────────────────
#│ SUN BOARD : admin.cgi - 2021/07/24
#│ copyright (c) kentweb, 1997-2021
#│ https://www.kent-web.com/
#└─────────────────────────────────

# モジュール宣言
use strict;
use CGI::Carp qw(fatalsToBrowser);
use vars qw(%in %cf);
use lib "./lib";
use CGI::Session;
use Digest::SHA::PurePerl qw(sha256_base64);

# 設定ファイル認識
require "./init.cgi";
%cf = set_init();

# データ受理
%in = parse_form();

# 認証
require "./lib/login.pl";
auth_login();

# 処理分岐
if ($in{data_men}) { data_men(); }
if ($in{pass_mgr}) { pass_mgr(); }

# メニュー画面
menu_html();

#-----------------------------------------------------------
#  メニュー画面
#-----------------------------------------------------------
sub menu_html {
	header("メニューTOP");
	print <<EOM;
<div id="body">
<div class="menu-msg">選択ボタンを押してください。</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<table class="form-tbl">
<tr>
	<th>選択</th>
	<th width="280">処理メニュー</th>
</tr><tr>
	<td><input type="submit" name="data_men" value="選択"></td>
	<td>データ管理</td>
</tr><tr>
	<td><input type="submit" name="pass_mgr" value="選択"></td>
	<td>パスワード管理</td>
</tr><tr>
	<td><input type="submit" name="logoff" value="選択"></td>
	<td>ログアウト</td>
</tr>
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  管理モード
#-----------------------------------------------------------
sub data_men {
	# 削除処理
	if ($in{job} eq "dele" && $in{no}) {
		
		# 削除情報
		my %del;
		for ( split(/\0/,$in{no}) ) { $del{$_}++; }
		
		# 削除情報をマッチング
		my @data;
		open(DAT,"+< $cf{datadir}/log.cgi");
		eval "flock(DAT,2);";
		while (<DAT>) {
			my ($no,$dat,$nam,$eml,$sub,$com,$url) = split(/<>/);
			
			if (!defined $del{$no}) { push(@data,$_); }
		}
		
		# 更新
		seek(DAT,0,0);
		print DAT @data;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		# HTMLファイル更新
		make_html(@data);
	
	# 修正画面
	} elsif ($in{job} eq "edit" && $in{no}) {
		
		my @data;
		open(IN,"$cf{datadir}/log.cgi");
		while (<IN>) {
			my ($no,$dat,$nam,$eml,$sub,$com,$url,$hos,$pwd,$tim) = split(/<>/);
			
			if ($in{no} == $no) {
				@data = ($no,$dat,$nam,$eml,$sub,$com,$url);
				last;
			}
		}
		close(IN);
		
		# 修正フォームへ
		edit_form(@data);
	
	# 修正実行
	} elsif ($in{job} eq "edit2") {
		
		# 未入力の場合
		if ($in{url} eq "http://") { $in{url} = ""; }
		$in{sub} ||= "無題";
		
		# 読み出し
		my @data;
		open(DAT,"+< $cf{datadir}/log.cgi");
		eval "flock(DAT,2);";
		while (<DAT>) {
			my ($no,$dat,$nam,$eml,$sub,$com,$url,$hos,$pwd,$tim) = split(/<>/);
			
			if ($in{no} == $no) {
				$_ = "$no<>$dat<>$in{name}<>$in{email}<>$in{sub}<>$in{comment}<>$in{url}<>$hos<>$pwd<>$tim<>\n";
			}
			push(@data,$_);
		}
		
		# 更新
		seek(DAT,0,0);
		print DAT @data;
		truncate(DAT,tell(DAT));
		close(DAT);
		
		# HTMLファイル更新
		make_html(@data);
	}
	
	# 削除画面を表示
	header("管理モード");
	print <<EOM;
<div id="body">
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="&lt; メニュー">
</form>
</div>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="data_men" value="1">
<input type="hidden" name="sid" value="$in{sid}">
処理：
<select name="job">
<option value="edit">修正</option>
<option value="dele">削除</option>
</select>
<input type="submit" value="送信する">
EOM

	# 記事を展開
	open(IN,"$cf{datadir}/log.cgi") or cgi_err("open err: log.cgi");
	while (<IN>) {
		my ($no,$dat,$nam,$eml,$sub,$com,$url,$hos,$pwd,$tim) = split(/<>/);
		$nam = qq|<a href="mailto:$eml">$nam</a>| if ($eml);
		
		print qq|<div class="log"><input type="checkbox" name="no" value="$no">\n|;
		print qq|[$no] <b class="sub">$sub</b> 投稿者：$nam - $dat [ $hos ]</div>\n|;
		print qq|<div class="com">| . cut_str($com,50) . qq|</div>\n|;
	}
	close(IN);
	
	print <<EOM;
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  修正フォーム
#-----------------------------------------------------------
sub edit_form {
	my ($no,$dat,$nam,$eml,$sub,$com,$url) = @_;
	
	$com =~ s|<br( /)?>|\n|g;
	$url ||= "http://";
	
	header("管理モード ＞ 修正フォーム");
	print <<EOM;
<div id="body">
<div class="back-btn">
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="data_men" value="1">
<input type="hidden" name="sid" value="$in{sid}">
<input type="submit" value="&lt; 前画面へ">
</form>
</div>
<ul>
<li>変更する部分のみ修正して送信ボタンを押してください。
</ul>
<form action="$cf{admin_cgi}" method="post">
<input type="hidden" name="data_men" value="1">
<input type="hidden" name="job" value="edit2">
<input type="hidden" name="no" value="$no">
<input type="hidden" name="sid" value="$in{sid}">
<table class="form-tbl">
<tr>
  <th>おなまえ</th>
  <td><input type="text" name="name" size="30" value="$nam"></td>
</tr><tr>
  <th>e-mail</b></td>
  <td><input type="text" name="email" size="30" value="$eml"></td>
</tr><tr>
  <th>タイトル</b></td>
  <td><input type="text" name="sub" size="50" value="$sub"></td>
</tr><tr>
  <th>参照先</b></td>
  <td><input type="text" name="url" size="50" value="$url"></td>
</tr><tr>
  <th>コメント</th>
  <td>
  		<textarea name="comment" cols="65" rows="10">$com</textarea><br>
		<input type="submit" value="送信する">
  </td>
</tr>
</table>
</form>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  HTMLヘッダー
#-----------------------------------------------------------
sub header {
	my $ttl = shift;
	
	print <<EOM;
Content-type: text/html; charset=utf-8

<!doctype html>
<html lang="ja">
<head>
<meta charset="UTF-8">
<link href="$cf{cmnurl}/admin.css" rel="stylesheet">
<title>$ttl</title>
</head>
<body>
<div id="head">:: SUN BOARD 管理画面 ::</div>
EOM
}

#-----------------------------------------------------------
#  エラー
#-----------------------------------------------------------
sub cgi_err {
	my $err = shift;
	
	header("ERROR!");
	print <<EOM;
<div id="body">
<div id="err">
<p><b>ERROR!</b></p>
<p>$err</p>
<p><input type="button" value="前画面に戻る" onclick="history.back()"></p>
</div>
</div>
</body>
</html>
EOM
	exit;
}

#-----------------------------------------------------------
#  文字カット for UTF-8
#-----------------------------------------------------------
sub cut_str {
	my ($str,$all) = @_;
	$str =~ s|<br( /)?>||g;
	
	my $i = 0;
	my ($ret,$flg);
	while ($str =~ /([\x00-\x7f]|[\xC0-\xDF][\x80-\xBF]|[\xE0-\xEF][\x80-\xBF]{2}|[\xF0-\xF7][\x80-\xBF]{3})/gx) {
		$i++;
		$ret .= $1;
		if ($i >= $all) {
			$flg++;
			last;
		}
	}
	$ret .= '...' if ($flg);
	
	return $ret;
}


