# モジュール宣言/変数初期化
use strict;
my %cf;
#┌─────────────────────────────────
#│ SUN BOARD : init.cgi - 2021/02/13
#│ copyright (c) kentweb, 1997-2022
#│ https://www.kent-web.com/
#└─────────────────────────────────
$cf{version} = 'Sun Board v8.3';
#┌─────────────────────────────────
#│ [留意事項]
#│ 1. このプログラムはフリーソフトです。このプログラムを使用した
#│    いかなる損害に対して作者は一切の責任を負いません。
#│ 2. 設置に関する質問はサポート掲示板にお願いいたします。
#│    直接メールによる質問は一切お受けいたしておりません。
#└─────────────────────────────────

#===========================================================
# ■ 設定項目
#===========================================================

# 掲示板タイトル
$cf{bbs_title} = '掲示板 - SUN BOARD';

# CGIファイルのディレクトリURL【URLパス】
$cf{cgi_url} = "http://www.example.com/sunbbs";

# HTMLファイルのディレクトリURL【URLパス】
$cf{html_url} = "http://www.example.com/sunbbs/html";

# HTMLファイルのディレクトリパス【サーバパス】
$cf{html_dir} = "./html";

# データディレクトリ【サーバパス】
$cf{datadir} = './data';

# テンプレートディレクトリ【サーバパス】
$cf{tmpldir} = './tmpl';

# 共通ディレクトリ【URLパス】
$cf{cmnurl} = './cmn';

# 戻り先 (index.htmlなど)【URLパス】
# → http://からの絶対パスで記述
$cf{homepage} = "http://www.example.com/";

# 文字コード自動判別（0=no 1=yes）
# → フォーム入力の文字コード判別を行う場合
$cf{conv_code} = 0;

# 記事の最大保持数
$cf{maxlog} = 100;

# ページ当りの記事数
$cf{pg_max} = 10;

# 自動リンク (0=no 1=yes)
$cf{autolink} = 1;

# 本体CGI [ ファイル名のみ ]
$cf{bbs_cgi} = 'sunbbs.cgi';

# 投稿CGI [ ファイル名のみ ]
$cf{regist_cgi} = 'regist.cgi';

# 管理CGI [ ファイル名のみ ]
$cf{admin_cgi} = 'admin.cgi';

# メール通知機能
# → 0=no  1=yes
$cf{mailing} = 0;

# メール通知先アドレス（メール通知する場合）
$cf{mailto} = 'xxx@xxx.xx';

# sendmailのパス（メール通知する場合）
$cf{sendmail} = '/usr/lib/sendmail';

# sendmailの -fコマンドが必要な場合
# 0=no 1=yes
$cf{sendm_f} = 0;

# 記事の更新は method=post に限定する場合（セキュリティ対策）
#  → 0=no 1=yes
$cf{postonly} = 1;

# 投稿制限（セキュリティ対策）
#  0 : しない
#  1 : 同一IPアドレスからの投稿間隔を制限する
#  2 : 全ての投稿間隔を制限する
$cf{regCtl} = 1;

# 制限投稿間隔（秒数）
# → $regCtl での投稿間隔
$cf{wait} = 60;

# 禁止ワード
# → 投稿時禁止するワードをコンマで区切る
$cf{no_wd} = '';

# 日本語チェック（投稿時日本語が含まれていなければ拒否する）
# 0=No  1=Yes
$cf{jp_wd} = 1;

# URL個数チェック
# → 投稿コメント中に含まれるURL個数の最大値
$cf{urlnum} = 1;

# アクセス制限（半角スペースで区切る、アスタリスク可）
#  → 拒否ホスト名を記述（後方一致）【例】*.anonymizer.com
$cf{deny_host} = '';
#  → 拒否IPアドレスを記述（前方一致）【例】210.12.345.*
$cf{deny_addr} = '';

# １回当りの最大投稿サイズ (bytes)
$cf{maxdata} = 51200;

# ホスト取得方法
# 0 : gethostbyaddr関数を使わない
# 1 : gethostbyaddr関数を使う
$cf{gethostbyaddr} = 0;

# クッキーID名（特に変更しなくてよい）
# → クッキー保存名
$cf{cookie_id} = "sunboard";

# 管理パスワードの最大間違い制限
# → この回数以上パスワードを間違うとロックします
$cf{max_failpass} = 5;

# 管理パスワードのロック期間：自動解除を日数で指定
# → この値を 0 にすると自動解除しません。
$cf{lock_days} = 14;

# -------------------------------------------------------------- #
# [ 以下は「過去ログ」機能を使用する場合の設定 ]
#
# 過去ログ生成 (0=no 1=yes)
$cf{pastkey} = 0;

# 過去ログ用NOファイル【サーバパス】
$cf{nofile}  = './data/pastno.dat';

# 過去ログのディレクトリ【サーバパス】
$cf{pastdir} = './data/past';

# 過去ログ１ファイルの行数
# → この行数を超えると次ページを自動生成します
$cf{max_line} = 500;

# -------------------------------------------------------------- #
# [ 以下は「画像認証機能」機能（スパム対策）を使用する場合の設定 ]
#
# 画像認証機能の使用
# 0 : しない
# 1 : ライブラリ版（pngren.pl）
# 2 : モジュール版（GD::SecurityImage + Image::Magick）→ Image::Magick必須
$cf{use_captcha} = 1;

# 認証用画像生成ファイル【URLパス】
$cf{captcha_cgi} = './captcha.cgi';

# 画像認証プログラム【サーバパス】
$cf{captcha_pl} = './lib/captcha.pl';
$cf{captsec_pl} = './lib/captsec.pl';
$cf{pngren_pl}  = './lib/pngren.pl';

# 画像認証機能用暗号化キー（暗号化/復号化をするためのキー）
# → 適当に変更してください。
$cf{captcha_key} = 'captchasunbbs';

# 投稿キー許容時間（分単位）
# → 投稿フォーム表示後、送信ボタンが押されるまでの可能時間。
$cf{cap_time} = 30;

# 投稿キーの文字数
# ライブラリ版 : 4～8文字で設定
# モジュール版 : 6～8文字で設定
$cf{cap_len} = 6;

# 画像/フォント格納ディレクトリ【サーバパス】
$cf{bin_dir} = './lib/bin';

# [ライブラリ版] 画像ファイル [ ファイル名のみ ]
$cf{si_png} = "stamp.png";

# [モジュール版] 画像フォント [ ファイル名のみ ]
$cf{font_ttl} = "tempest.ttf";

#===========================================================
# ■ 設定完了
#===========================================================

# 設定値を返す
sub set_init { return %cf; }

#-----------------------------------------------------------
#  フォームデコード
#-----------------------------------------------------------
sub parse_form {
	my ($buf,%in);
	if ($ENV{REQUEST_METHOD} eq "POST") {
		error('受理できません') if ($ENV{CONTENT_LENGTH} > $cf{maxdata});
		read(STDIN, $buf, $ENV{CONTENT_LENGTH});
	} else {
		$buf = $ENV{QUERY_STRING};
	}
	foreach ( split(/&/, $buf) ) {
		my ($key,$val) = split(/=/);
		$key =~ tr/+/ /;
		$key =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2", $1)/eg;
		$val =~ tr/+/ /;
		$val =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("H2", $1)/eg;
		
		# 無効化
		$val =~ s/&/&amp;/g;
		$val =~ s/</&lt;/g;
		$val =~ s/>/&gt;/g;
		$val =~ s/"/&quot;/g;
		$val =~ s/'/&#39;/g;
		$val =~ s|\r\n|<br>|g;
		$val =~ s|[\r\n]|<br>|g;
		
		$in{$key} .= "\0" if (defined $in{$key});
		$in{$key} .= $val;
	}
	return %in;
}

#-----------------------------------------------------------
#  エラー画面
#-----------------------------------------------------------
sub error {
	my $err = shift;
	
	open(IN,"$cf{tmpldir}/error.html") or die;
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!error!/$err/g;
	$tmpl =~ s/!css-url!/$cf{html_url}\/style.css/g;
	$tmpl =~ s|!bbs_title!|$cf{bbs_title}|g;
	
	print "Content-type: text/html; charset=utf-8\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  HTML生成処理
#-----------------------------------------------------------
sub make_html {
	my @log = @_;
	
	my $all = @log;
	
	open(IN,"$cf{tmpldir}/bbs.html") or error("open err: bbs.html");
	my $tmpl = join('',<IN>);
	close(IN);
	
	$tmpl =~ s/!homepage!/$cf{homepage}/g;
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{cgi_url}\/$cf{$1}/g;
	$tmpl =~ s/!css-url!/$cf{html_url}\/style.css/g;
	$tmpl =~ s/!bbs-(title|message)!/$cf{"bbs_$1"}/g;
	
	# 過去ログなしの場合、該当箇所を削除
	if ($cf{pastkey} == 0) {
		$tmpl =~ s|<!-- oldlog -->.+?<!-- /oldlog -->||s;
	}
	
	# テンプレート分割
	my ($head,$loop,$foot) = $tmpl =~ m|(.+)<!-- loop -->(.+?)<!-- /loop -->(.+)|s
			? ($1,$2,$3)
			: error('テンプレート不正');
	
	# 各ページ作成
	my $bbsno = 1;
	for ( my $i = 0; $i <= @log; $i += $cf{pg_max} ) {
		
		my $end = $i + $cf{pg_max} - 1;
		if ($end > $#log) { $end = $#log; }
		
		my $data;
		foreach ($i .. $end) {
			my ($no,$date,$nam,$eml,$sub,$com,$url,$hos,$pw,$time) = split(/<>/,$log[$_]);
			$nam = qq|<a href="mailto:$eml">$nam</a>| if ($eml);
			$com = auto_link($com) if ($cf{autolink});
			$com =~ s/([>]|^)(&gt;[^<]*)/$1<span class="refcol">$2<\/span>/g;
			$url &&= qq|<a href="$url" target="_top">$url</a>|;
			
			my $tmp = $loop;
			$tmp =~ s/!num!/$no/g;
			$tmp =~ s/!sub!/$sub/g;
			$tmp =~ s/!name!/$nam/g;
			$tmp =~ s/!email!/$eml/g;
			$tmp =~ s/!date!/$date/g;
			$tmp =~ s/!url!/$url/g;
			$tmp =~ s/!comment!/$com/g;
			$data .= $tmp;
		}
		
		# 生成ページ定義
		my $html;
		if ($i == 0) {
			$html = 'index.html';
		} else {
			$bbsno++;
			$html = "bbs-$bbsno.html";
		}
		
		# 繰越ボタン
		my $page_btn = make_pgbtn($all,$bbsno) if (@log > $cf{pg_max});
		my ($tmp1,$tmp2) = ($head,$foot);
		$tmp1 =~ s/<!-- pager -->/$page_btn/g;
		$tmp2 =~ s/<!-- pager -->/$page_btn/g;
		
		# フッタ部
		$tmp2 = footer($tmp2);
		
		# 書込み
		open(DAT,"+> $cf{html_dir}/$html") or error("write err: $html");
		eval "flock(DAT,2);";
		print DAT $tmp1, $data, $tmp2;
		close(DAT);
	}
	
	# HTMLインデックス更新
	open(IDX,"+< $cf{datadir}/html.dat") or error("open err: html.dat");
	my $data = <IDX>;
	seek(IDX,0,0);
	print IDX $bbsno;
	truncate(IDX,tell(IDX));
	close(IDX);
	
	# 不要HTML削除
	if ($bbsno < $data) {
		foreach my $i ($bbsno .. $data) {
			unlink("$cf{html_dir}/bbs-$i.html");
		}
	} elsif ($bbsno > $data) {
		foreach my $i ($data .. $bbsno) {
			chmod(0666,"$cf{html_dir}/bbs-$i.html");
		}
	}
}

#-----------------------------------------------------------
#  繰越ボタン作成
#-----------------------------------------------------------
sub make_pgbtn {
	my ($i,$pg) = @_;
	my $pg2 = ($pg - 1) * $cf{pg_max};
	
	# ページ繰越定義
	my $next = $pg2 + $cf{pg_max};
	my $back = $pg2 - $cf{pg_max};
	
	# ページ繰越ボタン作成
	my @pg;
	if ($back >= 0 or $next < $i) {
		my $flg;
		my ($w,$x,$y,$z) = (0,1,0,$i);
		while ($z > 0) {
			if ($pg == $x) {
				$flg++;
				push(@pg,qq!<span class="page active">$x</span>\n!);
			} else {
				my $link = $x == 1 ? 'index.html' : "bbs-$x.html";
				push(@pg,qq!<a href="$link" class="page gradient">$x</a>\n!);
			}
			$x++;
			$y += $cf{pg_max};
			$z -= $cf{pg_max};
			
			if ($flg) { $w++; }
			last if ($w >= 5 && @pg >= 10);
		}
	}
	while( @pg >= 11 ) { shift(@pg); }
	my $ret = join('', @pg);
	if ($back >= 0) {
		my $x = $back / $cf{pg_max} + 1;
		my $link = $x == 1 ? 'index.html' : "bbs-$x.html";
		$ret = qq!<a href="$link" class="page gradient">&laquo;</a>\n! . $ret;
	}
	if ($next < $i) {
		my $x = $next / $cf{pg_max} + 1;
		my $link = $x == 1 ? 'index.html' : "bbs-$x.html";
		$ret .= qq!<a href="$link" class="page gradient">&raquo;</a>\n!;
	}
	
	# 結果を返す
	return $ret ? qq|<div class="pager">\n$ret</div>| : '';
}

#-----------------------------------------------------------
#  フッター
#-----------------------------------------------------------
sub footer {
	my $foot = shift;
	
	# 著作権表記（削除・改変禁止）
	my $copy = <<EOM;
<p style="margin-top:2em;text-align:center;font-family:Verdana,Helvetica,Arial;font-size:10px;">
	- <a href="https://www.kent-web.com/" target="_top">SUN BOARD</a> -
</p>
EOM

	my $ret;
	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		$ret .= "$1$copy$2\n";
	} else {
		$ret .= "$foot$copy\n";
		$ret .= "</body></html>\n";
	}
	return $ret;
}

#-----------------------------------------------------------
#  自動リンク
#-----------------------------------------------------------
sub auto_link {
	my $text = shift;
	
	$text =~ s/(s?https?:\/\/([\w-.!~*'();\/?:\@=+\$,%#]|&amp;)+)/<a href="$1" target="_blank">$1<\/a>/g;
	return $text;
}



1;

