#!/usr/local/bin/perl

#
# YY-CHAT : init.cgi - 2011/10/02
# Copyright(C) KentWeb
# http://www.kent-web.com/
#

# W[錾
use strict;
use CGI::Carp qw(fatalsToBrowser);

# ݒt@CF
require "./init.cgi";
my %cf = &init;

# f[^
my %in = &parse_form;

# 
&deny_host;
if ($in{mode} eq 'form') { &form1; }
if ($in{mode} eq 'into') { &form2; }
if ($in{comment} && $in{mode} eq 'regist') { &regist; }
if ($in{mode} eq 'out') { &room_out; }
&chat_data;

#-----------------------------------------------------------
#  tH[1 : 
#-----------------------------------------------------------
sub form1 {
	# NbL[擾
	my ($ck_nam,$ck_col,$ck_ret,$ck_lin,$ck_ico) = &get_cookie;
	$ck_col = $ck_col ne '' ? $ck_col : 0;
	$ck_ret = $ck_ret ne '' ? $ck_ret : $cf{retime_defo};
	$ck_lin = $ck_lin ne '' ? $ck_lin : $cf{lines_defo};

	my ($op_retime,$op_lines,$op_icon,$colors);
	foreach (@{$cf{retime}}) {
		if ($ck_ret == $_) {
			$op_retime .= qq|<option value="$_" selected>$_b\n|;
		} else {
			$op_retime .= qq|<option value="$_">$_b\n|;
		}
	}
	foreach (@{$cf{lines}}) {
		if ($ck_lin == $_) {
			$op_lines .= qq|<option value="$_" selected>$_s\n|;
		} else {
			$op_lines .= qq|<option value="$_">$_s\n|;
		}
	}
	foreach (0 .. $#{$cf{icon}}) {
		my (undef,$nam) = split(/,/, $cf{icon}->[$_]);
		if ($ck_ico == $_) {
			$op_icon .= qq|<option value="$_" selected>$nam\n|;
		} else {
			$op_icon .= qq|<option value="$_">$nam\n|;
		}
	}
	foreach (0 .. $#{$cf{colors}}) {
		my ($col,undef) = split(/,/, $cf{colors}->[$_]);
		if ($ck_col == $_) {
			$colors .= qq|<input type="radio" name="color" value="$_" checked>|;
		} else {
			$colors .= qq|<input type="radio" name="color" value="$_">|;
		}
		$colors .= qq|<span style="color:$col"></span>\n|;

		if ($_ == int(@{$cf{colors}}/2)-1) { $colors .= "<br>\n"; }
	}

	open(IN,"$cf{tmpldir}/form.html") or &error("open err: form.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!chat_title!/$cf{chat_title}/g;
	$tmpl =~ s/!chat_cgi!/$cf{chat_cgi}/g;
	$tmpl =~ s/!homepage!/$cf{homepage}/g;
	$tmpl =~ s/!colors!/$colors/g;
	$tmpl =~ s/!name!/$ck_nam/g;
	$tmpl =~ s/<!-- op_retime -->/$op_retime/g;
	$tmpl =~ s/<!-- op_lines -->/$op_lines/g;
	$tmpl =~ s/<!-- op_icon -->/$op_icon/g;

	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  tH[2 : tH[
#-----------------------------------------------------------
sub form2 {
	&regist('into');

	# NbL[ۑ
	&set_cookie($in{name},$in{color},$in{retime},$in{lines},$in{icon});

	my ($op_retime,$op_lines,$op_colors,$op_icon,$op_faces);
	foreach (@{$cf{retime}}) {
		if ($in{retime} == $_) {
			$op_retime .= qq|<option value="$_" selected>$_b\n|;
		} else {
			$op_retime .= qq|<option value="$_">$_b\n|;
		}
	}
	foreach (@{$cf{lines}}) {
		if ($in{lines} == $_) {
			$op_lines .= qq|<option value="$_" selected>$_s\n|;
		} else {
			$op_lines .= qq|<option value="$_">$_s\n|;
		}
	}
	foreach (0 .. $#{$cf{colors}}) {
		my (undef,$nam) = split(/,/, $cf{colors}->[$_]);
		if ($in{color} == $_) {
			$op_colors .= qq|<option value="$_" selected>$nam\n|;
		} else {
			$op_colors .= qq|<option value="$_">$nam\n|;
		}
	}
	foreach (0 .. $#{$cf{icon}}) {
		my (undef,$nam) = split(/,/, $cf{icon}->[$_]);
		if ($in{icon} == $_) {
			$op_icon .= qq|<option value="$_" selected>$nam\n|;
		} else {
			$op_icon .= qq|<option value="$_">$nam\n|;
		}
	}
	foreach (@{$cf{faces}}) {
		$op_faces .= qq|<option value="$_">$_\n|;
	}

	open(IN,"$cf{tmpldir}/form2.html") or &error("open err: form2.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!chat_title!/$cf{chat_title}/g;
	$tmpl =~ s/!([a-z]+_cgi)!/$cf{$1}/g;
	$tmpl =~ s/!homepage!/$cf{homepage}/g;
	$tmpl =~ s/!name!/$in{name}/g;
	$tmpl =~ s/!icon!/$in{icon}/g;
	$tmpl =~ s/!enam!/&url_encode($in{name})/eg;
	$tmpl =~ s/<!-- op_retime -->/$op_retime/g;
	$tmpl =~ s/<!-- op_lines -->/$op_lines/g;
	$tmpl =~ s/<!-- op_icon -->/$op_icon/g;
	$tmpl =~ s/<!-- op_colors -->/$op_colors/g;
	$tmpl =~ s/<!-- op_faces -->/$op_faces/g;
	$tmpl =~ s|!image!|"$cf{imgurl}/" . (split(/,/, $cf{icon}->[$in{icon}]))[0]|eg;

	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  L\
#-----------------------------------------------------------
sub chat_data {
	my $meta;
	if ($in{retime} != 0) {
		my $enam = &url_encode($in{name});
		$meta = qq|<meta http-equiv="refresh" content="$in{retime}; url=$cf{chat_cgi}?retime=$in{retime}&lines=$in{lines}&name=$enam">|;
	}

	# [h/s
	my $retime = $in{retime} ? "$in{retime}b" : "蓮";
	$in{lines} ||= $cf{lines_defo};

	# ݎ
	my ($num,$member) = &member;

	open(IN,"$cf{tmpldir}/data.html") or &error("open err: data.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!member!/$member/g;
	$tmpl =~ s/!num!/$num/g;
	$tmpl =~ s/!retime!/$retime/g;
	$tmpl =~ s/!lines!/$in{lines}/g;
	$tmpl =~ s/<!-- meta_refresh -->/$meta/;
	$tmpl =~ s/!lines!/$in{lines}/g;

	# ev[g
	my ($head,$loop,$foot);
	if ($tmpl =~ /(.+)<!-- loop_begin -->(.+)<!-- loop_end -->(.+)/s) {
		($head,$loop,$foot) = ($1,$2,$3);
	} else {
		&error("ev[gsł");
	}

	print "Content-type: text/html\n\n";
	print $head;

	my $i;
	open(IN,"$cf{logfile}") or &error("open err: $cf{logfile}");
	while (<IN>) {
		$i++;
		my ($date,$name,$com,$col,$ico,undef) = split(/<>/);
		$ico &&= qq|<img src="$cf{imgurl}/$ico" align="left" alt="">|;

		my $tmp = $loop;
		$tmp =~ s|!name!|<span style="color:$col">$name</span>|g;
		$tmp =~ s|!comment!|<span style="color:$col">$com</span>|g;
		$tmp =~ s|!date!|$date|g;
		$tmp =~ s|!icon!|$ico|g;
		print $tmp;

		# \
		last if ($i >= $in{lines});
	}
	close(IN);

	# tb^
	&footer($foot);
}

#-----------------------------------------------------------
#  
#-----------------------------------------------------------
sub regist {
	my $job = shift;

	# O̓͂Ȃ΃G[
	if ($in{name} eq "") { &error("O̓͂܂"); }

	# /zXg
	my $host = $ENV{REMOTE_ADDR};
	my ($sec,$min,$hour,$mday,$mon) = localtime();
	my $date = sprintf("%s/%s-%02d:%02d:%02d",$mon+1,$mday,$hour,$min,$sec);

	my ($name,$color,$icon);
	if ($job eq 'into') {
		$in{comment} = "<b>$in{name}</b>$cf{msg_in}";
		$name  = $cf{master};
		$color = $cf{rep_color};

	} elsif ($job eq 'out') {
		$in{comment} = "<b>$in{name}</b>$cf{msg_out}";
		$name  = $cf{master};
		$color = $cf{rep_color};

	} else {
		$name  = "<b>$in{name}</b>";
		$color = (split(/,/, $cf{colors}->[$in{color}]))[0];
		$icon  = (split(/,/, $cf{icon}->[$in{icon}]))[0];
	}

	# OJ
	open(DAT,"+< $cf{logfile}") || &error("open err: $cf{logfile}");
	eval "flock(DAT, 2);";
	my @data = <DAT>;

	## clear Ɠ͂邱ƂŎ̋L폜
	if ($in{comment} eq 'clear'){
		my @temp;
		my $match;
		foreach (@data) {
			my ($hos) = (split(/<>/))[5];
			if ($host eq $hos) { $match = 1; }
			else { push(@temp,$_); }
		}
		if ($match) {
			@data = @temp;
			$in{comment} = "All Clear (^-^)v";
		}
	}

	# őL
	while ($cf{maxlog} <= @data) { pop(@data); }

	$in{comment} .= " $in{face}" if ($in{face});
	$in{comment} =~ s|\(\*\O\O\*\)|(<span style="color:red">*</span>OO<span style="color:red">*</span>)|g;

	# OtH[}bgčXV
	unshift (@data,"$date<>$name<>$in{comment}<>$color<>$icon<>$host<>\n");
	seek(DAT, 0, 0);
	print DAT @data;
	truncate(DAT, tell(DAT));
	close(DAT);
}

#-----------------------------------------------------------
#  ގ
#-----------------------------------------------------------
sub room_out {
	&regist('out');
	&member('out');

	open(IN,"$cf{tmpldir}/out.html") or &error("open err: out.html");
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!homepage!/$cf{homepage}/g;
	$tmpl =~ s/!chat_title!/$cf{chat_title}/g;
	$tmpl =~ s/!name!/$in{name}/g;

	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  G[
#-----------------------------------------------------------
sub error {
	my $err = shift;

	open(IN,"$cf{tmpldir}/error.html") or die;
	my $tmpl = join('', <IN>);
	close(IN);

	$tmpl =~ s/!error!/$err/g;

	print "Content-type: text/html\n\n";
	print $tmpl;
	exit;
}

#-----------------------------------------------------------
#  ݎǗ
#-----------------------------------------------------------
sub member {
	my $job = shift;

	# /IP擾
	my $now = time;
	my $addr = $ENV{REMOTE_ADDR};

	my ($i,$member,$flg,@log);
	open(DAT,"+< $cf{memfile}") or &error("open err: $cf{memfile}");
	eval "flock(DAT, 2);";
	while(<DAT>) {
		my ($time,$name,$ip) = split(/<>/);

		# 60bȏ㔭̂Ȃ҂͍폜
		if ($now - 60 > $time) {
			$flg = 1;
			next;
		}

		if ($addr eq $ip) {
			$flg = 2;

			# ގҍ폜
			if ($job eq 'out') {
				next;

			# /OXV
			} else {
				$name = $in{name};
				$_ = "$now<>$name<>$addr<>\n";
			}
		}

		# XVpzɒǉ
		push(@log,$_);

		# Qҕ\p쐬
		if ($i % 2) {
			$member .= "$name";
			$i++;
		} else {
			$member .= "$name";
			$i++;
		}
	}

	# VKQҒǉ
	if (!$flg && $job ne 'out' && $in{name} ne '') {
		$flg = 3;
		push(@log,"$now<>$in{name}<>$addr<>\n");
		$member = $i % 2 ? "$member$in{name}" : "$member$in{name}";
	}

	# QҐ
	my $num = @log;

	# t@CXV
	if ($job || $flg) {
		seek(DAT, 0, 0);
		print DAT @log;
		truncate(DAT, tell(DAT));
	}
	close(DAT);

	return ($num,$member);
}

#-----------------------------------------------------------
#  IPANZX
#-----------------------------------------------------------
sub deny_host {
	my $addr = $ENV{REMOTE_ADDR};
	my $flg;
	open(IN,"$cf{denyfile}") || &error("open err: $cf{denyfile}");
	while (<IN>) {
		chomp;
		next if (!$_);
		s/\*/\.\*/g;
		if ($addr =~ /$_/i) { $flg++; last; }
	}
	close(IN);

	&error('\󂠂܂񂪌݂pł܂') if ($flg);
}

#-----------------------------------------------------------
#  URLGR[h
#-----------------------------------------------------------
sub url_encode {
	local($_) = @_;

	s/(\W)/'%' . unpack('H2', $1)/eg;
	s/\s/+/g;
	$_;
}

#-----------------------------------------------------------
#  tb^[
#-----------------------------------------------------------
sub footer {
	my $foot = shift;

	# 쌠\Li폜Eϋ֎~j
	my $copy = <<EOM;
<p style="margin-top:2em;text-align:center;font-family:verdana,helvetica,arial;font-size:10px;">
- <a href="http://www.kent-web.com/" target="_top">YY-CHAT</a> -
</p>
EOM

	if ($foot =~ /(.+)(<\/body[^>]*>.*)/si) {
		print "$1$copy$2\n";
	} else {
		print "$foot$copy\n";
		print "</body></html>\n";
	}
	exit;
}

#-----------------------------------------------------------
#  NbL[s
#-----------------------------------------------------------
sub set_cookie {
	my @data = @_;

	my ($sec,$min,$hour,$mday,$mon,$year,$wday,undef,undef) = gmtime(time + 60*24*60*60);
	my @mon  = qw|Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec|;
	my @week = qw|Sun Mon Tue Wed Thu Fri Sat|;

	# tH[}bg
	my $gmt = sprintf("%s, %02d-%s-%04d %02d:%02d:%02d GMT",
				$week[$wday],$mday,$mon[$mon],$year+1900,$hour,$min,$sec);

	# URLGR[h
	my $cook;
	foreach (@data) {
		s/(\W)/sprintf("%%%02X", unpack("C", $1))/eg;
		$cook .= "$_<>";
	}

	print "Set-Cookie: yy_chat=$cook; expires=$gmt\n";
}

#-----------------------------------------------------------
#  NbL[擾
#-----------------------------------------------------------
sub get_cookie {
	# NbL[擾
	my $cook = $ENV{HTTP_COOKIE};

	# YIDo
	my %cook;
	foreach ( split(/;/, $cook) ) {
		my ($key,$val) = split(/=/);
		$key =~ s/\s//g;
		$cook{$key} = $val;
	}

	# URLfR[h
	my @cook;
	foreach ( split(/<>/, $cook{yy_chat}) ) {
		s/%([0-9A-Fa-f][0-9A-Fa-f])/pack("H2", $1)/eg;
		s/[&"'<>]//g;

		push(@cook,$_);
	}
	return @cook;
}

